/*
 * Decompiled with CFR 0.152.
 */
package artifacts.client.renderer;

import artifacts.client.model.entity.ModelMimic;
import artifacts.client.model.entity.ModelMimicInterior;
import artifacts.common.entity.EntityMimic;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.common.eventhandler.Event;

@ParametersAreNonnullByDefault
public class RenderMimic
extends RenderLiving<EntityMimic> {
    public static final Factory FACTORY = new Factory();
    private static final ResourceLocation MIMIC_TEXTURE = new ResourceLocation("artifacts", "textures/entity/mimic/mimic.png");
    private static final ResourceLocation VANILLA_CHEST = new ResourceLocation("textures/entity/chest/normal.png");
    private ModelBase secondModel = new ModelMimicInterior();

    protected RenderMimic(RenderManager renderManager) {
        super(renderManager, (ModelBase)new ModelMimic(), 0.45f);
    }

    protected ResourceLocation getEntityTexture(EntityMimic entity) {
        return VANILLA_CHEST;
    }

    protected ResourceLocation getSecondaryEntityTexture(EntityMimic entity) {
        return MIMIC_TEXTURE;
    }

    public void doRender(EntityMimic entity, double x, double y, double z, float entityYaw, float partialTicks) {
        boolean shouldSit;
        if (MinecraftForge.EVENT_BUS.post((Event)new RenderLivingEvent.Pre((EntityLivingBase)entity, (RenderLivingBase)this, partialTicks, x, y, z))) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179129_p();
        this.field_77045_g.field_78095_p = this.secondModel.field_78095_p = this.func_77040_d((EntityLivingBase)entity, partialTicks);
        this.field_77045_g.field_78093_q = this.secondModel.field_78093_q = (shouldSit = entity.func_184218_aH() && entity.func_184187_bx() != null && entity.func_184187_bx().shouldRiderSit());
        this.field_77045_g.field_78091_s = this.secondModel.field_78091_s = entity.func_70631_g_();
        try {
            float f = this.func_77034_a(entity.field_70760_ar, entity.field_70761_aq, partialTicks);
            float f1 = this.func_77034_a(entity.field_70758_at, entity.field_70759_as, partialTicks);
            float f2 = f1 - f;
            if (shouldSit && entity.func_184187_bx() instanceof EntityLivingBase) {
                EntityLivingBase entitylivingbase = (EntityLivingBase)entity.func_184187_bx();
                f = this.func_77034_a(entitylivingbase.field_70760_ar, entitylivingbase.field_70761_aq, partialTicks);
                f2 = f1 - f;
                float f3 = MathHelper.func_76142_g((float)f2);
                if (f3 < -85.0f) {
                    f3 = -85.0f;
                }
                if (f3 >= 85.0f) {
                    f3 = 85.0f;
                }
                f = f1 - f3;
                if (f3 * f3 > 2500.0f) {
                    f += f3 * 0.2f;
                }
                f2 = f1 - f;
            }
            float f7 = entity.field_70127_C + (entity.field_70125_A - entity.field_70127_C) * partialTicks;
            this.func_77039_a((EntityLivingBase)entity, x, y, z);
            float f8 = this.func_77044_a((EntityLivingBase)entity, partialTicks);
            this.func_77043_a((EntityLivingBase)entity, f8, f, partialTicks);
            float f4 = this.func_188322_c((EntityLivingBase)entity, partialTicks);
            float f5 = 0.0f;
            float f6 = 0.0f;
            if (!entity.func_184218_aH()) {
                f5 = entity.field_184618_aE + (entity.field_70721_aZ - entity.field_184618_aE) * partialTicks;
                f6 = entity.field_184619_aG - entity.field_70721_aZ * (1.0f - partialTicks);
                if (entity.func_70631_g_()) {
                    f6 *= 3.0f;
                }
                if (f5 > 1.0f) {
                    f5 = 1.0f;
                }
                f2 = f1 - f;
            }
            GlStateManager.func_179141_d();
            this.field_77045_g.func_78086_a((EntityLivingBase)entity, f6, f5, partialTicks);
            this.secondModel.func_78086_a((EntityLivingBase)entity, f6, f5, partialTicks);
            this.field_77045_g.func_78087_a(f6, f5, f8, f2, f7, f4, (Entity)entity);
            this.secondModel.func_78087_a(f6, f5, f8, f2, f7, f4, (Entity)entity);
            if (this.field_188301_f) {
                boolean flag1 = this.func_177088_c((EntityLivingBase)entity);
                GlStateManager.func_179142_g();
                GlStateManager.func_187431_e((int)this.func_188298_c((Entity)entity));
                if (!this.field_188323_j) {
                    this.renderModel(entity, f6, f5, f8, f2, f7, f4);
                }
                this.func_177093_a((EntityLivingBase)entity, f6, f5, partialTicks, f8, f2, f7, f4);
                GlStateManager.func_187417_n();
                GlStateManager.func_179119_h();
                if (flag1) {
                    this.func_180565_e();
                }
            } else {
                boolean flag = this.func_177090_c((EntityLivingBase)entity, partialTicks);
                this.renderModel(entity, f6, f5, f8, f2, f7, f4);
                if (flag) {
                    this.func_177091_f();
                }
                GlStateManager.func_179132_a((boolean)true);
                this.func_177093_a((EntityLivingBase)entity, f6, f5, partialTicks, f8, f2, f7, f4);
            }
            GlStateManager.func_179101_C();
        }
        catch (Exception exception) {
            // empty catch block
        }
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179098_w();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
        GlStateManager.func_179089_o();
        GlStateManager.func_179121_F();
        if (!this.field_188301_f) {
            this.func_177067_a((EntityLivingBase)entity, x, y, z);
        }
        MinecraftForge.EVENT_BUS.post((Event)new RenderLivingEvent.Post((EntityLivingBase)entity, (RenderLivingBase)this, partialTicks, x, y, z));
    }

    protected void renderModel(EntityMimic entitylivingbaseIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor) {
        boolean flag1;
        boolean flag = this.func_193115_c((EntityLivingBase)entitylivingbaseIn);
        boolean bl = flag1 = !flag && !entitylivingbaseIn.func_98034_c((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        if (flag || flag1) {
            if (!this.func_180548_c((Entity)entitylivingbaseIn)) {
                return;
            }
            if (flag1) {
                GlStateManager.func_187408_a((GlStateManager.Profile)GlStateManager.Profile.TRANSPARENT_MODEL);
                this.field_77045_g.func_78088_a((Entity)entitylivingbaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor);
                GlStateManager.func_187440_b((GlStateManager.Profile)GlStateManager.Profile.TRANSPARENT_MODEL);
            } else {
                this.field_77045_g.func_78088_a((Entity)entitylivingbaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor);
            }
            if (!this.bindSecondaryTexture(entitylivingbaseIn)) {
                return;
            }
            if (flag1) {
                GlStateManager.func_187408_a((GlStateManager.Profile)GlStateManager.Profile.TRANSPARENT_MODEL);
                this.secondModel.func_78088_a((Entity)entitylivingbaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor);
                GlStateManager.func_187440_b((GlStateManager.Profile)GlStateManager.Profile.TRANSPARENT_MODEL);
            } else {
                this.secondModel.func_78088_a((Entity)entitylivingbaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor);
            }
        }
    }

    private boolean bindSecondaryTexture(EntityMimic entity) {
        ResourceLocation resourcelocation = this.getSecondaryEntityTexture(entity);
        if (resourcelocation == null) {
            return false;
        }
        this.func_110776_a(resourcelocation);
        return true;
    }

    public static class Factory
    implements IRenderFactory<EntityMimic> {
        public Render<? super EntityMimic> createRenderFor(RenderManager manager) {
            return new RenderMimic(manager);
        }
    }
}

